<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('data_trava');
			$table->double('max_multiplier');
			$table->decimal('max_prize', 10,2);
			$table->integer('min_games_on_bet');
			$table->integer('max_games_on_bet');
			$table->decimal('max_bet_value', 10,2);
			$table->integer('bets_on_game_per_day');
			$table->double('min_odd_per_bet');
			$table->integer('cancel_bet_time');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}