<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Name', 45);
			$table->longText('Descript');
			$table->string('type', 20);
			$table->longText('Photo');
			$table->char('Class', 5);
			$table->decimal('Price');
			$table->integer('Quantity');
			$table->boolean('status');
			$table->integer('userid')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}