<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('userid')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->foreign('userid')->references('id')->on('Rules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->foreign('Orderid')->references('id')->on('Order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->foreign('bookingid')->references('id')->on('Booking')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Booking', function(Blueprint $table) {
			$table->foreign('prodid')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_userid_foreign');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->dropForeign('bills_userid_foreign');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->dropForeign('bills_Orderid_foreign');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->dropForeign('bills_bookingid_foreign');
		});
		Schema::table('Booking', function(Blueprint $table) {
			$table->dropForeign('Booking_prodid_foreign');
		});
	}
}