<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 200);
			$table->bigInteger('siret')->unique();
			$table->bigInteger('siren')->unique();
			$table->string('address');
			$table->string('city');
			$table->string('postal_code');
			$table->string('country');
			$table->string('phone');
			$table->string('contact_name');
			$table->boolean('archived')->default(0);
			$table->bigInteger('region_id')->unsigned()->nullable();
			$table->bigInteger('sector_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}