<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('event', function(Blueprint $table) {
			$table->foreign('statusId')->references('id')->on('event_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->foreign('createdBy')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->foreign('updatedBy')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('event', function(Blueprint $table) {
			$table->dropForeign('event_statusId_foreign');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->dropForeign('event_createdBy_foreign');
		});
		Schema::table('event', function(Blueprint $table) {
			$table->dropForeign('event_updatedBy_foreign');
		});
	}
}