<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lookup extends Model 
{

    protected $table = 'lookups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function parent()
    {
        return $this->belongsTo('Lookup');
    }

    public function children()
    {
        return $this->hasMany('Lookup');
    }

    public function facilityDistances()
    {
        return $this->hasMany('FacilityDistance');
    }

}