<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('meta_title_en');
			$table->string('meta_title_ar');
			$table->longText('description_en');
			$table->longText('description_ar');
			$table->text('meta_descriotion_en');
			$table->text('meta_descriotion_ar');
			$table->boolean('is_featured')->default(true);
			$table->boolean('is_published')->default(true);
			$table->integer('views');
			$table->enum('type', array('video', 'image'));
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}