<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCareersTable extends Migration {

	public function up()
	{
		Schema::create('careers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('meta_title_en');
			$table->string('meta_title_ar');
			$table->text('description_en');
			$table->text('description_ar');
			$table->text('meta_descriotion_en');
			$table->text('meta_descriotion_ar');
			$table->enum('type', array('Part-Time', 'Full-Time'));
			$table->json('salary_range');
			$table->integer('number_of_available_vacancies');
			$table->boolean('is_active')->default(true);
			$table->boolean('show_salary')->default(false);
			$table->boolean('seo_index');
		});
	}

	public function down()
	{
		Schema::drop('careers');
	}
}