<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrenciesTable extends Migration {

	public function up()
	{
		Schema::create('currencies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('priority');
			$table->string('iso_code');
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('symbol');
			$table->string('subunit');
			$table->integer('subunit_to_unit');
			$table->tinyInteger('symbol_first');
			$table->string('html_entity');
			$table->string('decimal_mark');
			$table->string('thousands_separator');
			$table->integer('iso_numeric');
			$table->integer('exchange_rate');
		});
	}

	public function down()
	{
		Schema::drop('currencies');
	}
}