<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactUsTable extends Migration {

	public function up()
	{
		Schema::create('contact_us', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name');
			$table->string('email');
			$table->string('phone_number');
			$table->longText('message');
			$table->boolean('is_readed')->default(false);
			$table->mediumText('link');
			$table->date('best_time_to_call_from');
			$table->date('best_time_to_call_to');
		});
	}

	public function down()
	{
		Schema::drop('contact_us');
	}
}