<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevelopersTable extends Migration {

	public function up()
	{
		Schema::create('developers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('meta_title_en');
			$table->string('meta_title_ar');
			$table->text('description_en');
			$table->text('description_ar');
			$table->text('meta_descriotion_en');
			$table->text('meta_descriotion_ar');
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->integer('developer_id')->unsigned();
			$table->boolean('seo_index')->default(true);
			$table->boolean('is_featured')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('developers');
	}
}