<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Developer extends Eloquent {

	protected $table = 'developers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function projects()
	{
		return $this->hasMany('Project');
	}

	public function developer()
	{
		return $this->belongsTo('User');
	}

	public function country()
	{
		return $this->belongsTo('Location');
	}

	public function city()
	{
		return $this->belongsTo('Location');
	}

	public function region()
	{
		return $this->belongsTo('Location');
	}

}