<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lookup extends Eloquent {

	protected $table = 'lookups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function parent()
	{
		return $this->belongsTo('Lookup');
	}

	public function children()
	{
		return $this->hasMany('Lookup');
	}

	public function facilityDistances()
	{
		return $this->hasMany('FacilityDistance');
	}

}