<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Package extends Eloquent {

	protected $table = 'packages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function items()
	{
		return $this->hasMany('PackageItem');
	}

	public function subscriptions()
	{
		return $this->hasMany('Subscription');
	}

}