<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_id')->index();
			$table->integer('customer_id')->index();
			$table->string('code', 255);
			$table->datetime('date');
			$table->string('status', 255);
			$table->string('delivery_type', 255);
			$table->string('collector_name', 255);
			$table->string('collector_emirates_id', 255);
			$table->datetime('collected_at');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}