<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_id')->index();
			$table->string('username', 255);
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->tinyInteger('admin');
			$table->string('reset_password', 255);
			$table->string('reset_password_token', 255);
			$table->string('reset_password_sent_at', 255);
			$table->string('remember_created_at', 255);
			$table->integer('sign_in_count');
			$table->string('current_sign_in_at', 255);
			$table->string('last_sign_in_at', 255);
			$table->string('remember_token', 100);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}