<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->morphs('rateable');
			$table->bigInteger('user_id')->unsigned();
			$table->decimal('rate');
			$table->string('comment');
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}