<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnersDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('partnersDocuments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('partnerId');
			$table->integer('documentTyp')->unsigned();
			$table->string('creatorId')->nullable();
			$table->string('documentName');
			$table->text('documentLocation')->default('255');
			$table->datetime('documentExpired')->nullable();
			$table->enum('ifExpired', array('suspension', 'suspension10', 'suspension20', 'suspension30', 'suspension40', 'suspension50', 'nothing'));
		});
	}

	public function down()
	{
		Schema::drop('partnersDocuments');
	}
}