<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Staff extends Model 
{

    protected $table = 'STAFF';
    public $timestamps = false;
    protected $guarded = array('ID');
    protected $fillable = array('FIRST_NAME', 'LAST_NAME', 'PHONE', 'ADDRESS', 'PHOTO', 'EMAIL', 'ROLE', 'USER_NAME', 'PASSWORD');
    protected $hidden = array('PASSWORD', 'remember_token');

    public function Doctor()
    {
        return $this->hasOne('App\DOCTOR', 'STAFF_ID', 'ID');
    }

    public function Laboratory()
    {
        return $this->hasOne('App\LABORATORY', 'STAFF_ID', 'ID');
    }

}