<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSTAFFTable extends Migration {

	public function up()
	{
		Schema::create('STAFF', function(Blueprint $table) {
			$table->increments('ID');
			$table->string('FIRST_NAME', 32);
			$table->string('LAST_NAME', 32);
			$table->string('PHONE', 32);
			$table->string('ADDRESS', 255);
			$table->binary('PHOTO');
			$table->string('EMAIL', 60);
			$table->integer('ROLE');
			$table->string('USER_NAME', 32)->unique();
			$table->string('PASSWORD', 60);
			$table->string('remember_token', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('STAFF');
	}
}