<?php

namespace App;

class MEDICAL_RECORD extends Eloquent {

	protected $table = 'MEDICALS_RECORDS';
	public $timestamps = false;
	protected $fillable = array('DOCTOR_ID', 'PATIENT_ID', 'SYMPTOMS_OF_PATIENT', 'MEDICAL_RECORD_DATE', 'NEXT_INTERVIEW', 'NEXT_INTERVIEW_DATE', 'NOTES');

	public function PositiveDisease()
	{
		return $this->hasMany('App\POSITIVE_DISEASE', 'MEDICAL_RECORD_ID', 'ID');
	}

	public function RequiredAnalysis()
	{
		return $this->hasMany('App\REQUIRED_ANALYZE', 'MEDICAL_RECORD_ID', 'ID');
	}

	public function RequiredTreatment()
	{
		return $this->hasMany('App\REQUIRED_TREATMENT', 'MEDICAL_RECORD_ID', 'ID');
	}

	public function Doctor()
	{
		return $this->belongsTo('App\DOCTOR', 'DOCTOR_ID', 'ID');
	}

	public function Patient()
	{
		return $this->belongsTo('App\PATIENT', 'PATIENT_ID', 'ID');
	}

}