<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfessionalSpecialityTable extends Migration {

	public function up()
	{
		Schema::create('professional_speciality', function(Blueprint $table) {
			$table->increments('id');
			$table->string('profession', 255)->index();
			$table->string('speciality', 255)->index();
			$table->tinyInteger('status')->index()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('professional_speciality');
	}
}