<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Feedback extends Model 
{

    protected $table = 'feedback';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('scenario_id', 'note', 'status', 'user_id');

    public function scenario()
    {
        return $this->belongsTo('Scenario', 'scenario_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}