<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Scenario extends Model 
{

    protected $table = 'scenario';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('phase_id', 'title', 'note', 'status', 'user_id');

    public function phase()
    {
        return $this->belongsTo('Phase', 'phase_id');
    }

    public function feedbacks()
    {
        return $this->hasMany('Feedback', 'scenario_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}