<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnrollStudentsTable extends Migration {

	public function up()
	{
		Schema::create('enroll_students', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('batch_id')->unsigned();
			$table->integer('student_id')->unsigned();
			$table->enum('type', array('0', '1'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('enroll_students');
	}
}