<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonTable extends Migration {

	public function up()
	{
		Schema::create('lesson', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned();
			$table->string('name');
			$table->string('slug');
			$table->integer('type_id')->unsigned();
			$table->longText('description');
			$table->integer('position')->default('0');
			$table->tinyInteger('is_active')->default('1');
			$table->integer('created_by');
			$table->string('created_slug');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lesson');
	}
}