<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacementTable extends Migration {

	public function up()
	{
		Schema::create('placement', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->string('job_title')->nullable();
			$table->longText('job_description')->nullable();
			$table->date('last_date')->nullable();
			$table->text('short_description')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('placement');
	}
}