<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reponse extends Eloquent {

	protected $table = 'reponses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('libele', 'add_by', 'statut', 'id_intent');
	protected $visible = array('libele', 'add_by', 'statut', 'id_intent');

	public function intent()
	{
		return $this->belongsTo('App\Models\Intent', 'id_intent');
	}

	public function create_by()
	{
		return $this->belongsTo('App\Models\User', 'add_by');
	}

}