<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ssow_employee', function(Blueprint $table) {
			$table->foreign('ssow_id')->references('id')->on('ssow_training')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ssow_employee', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ssow_training', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('ssow_course')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ssow_training', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('ssow_employee')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ssow_course', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('ssow_category')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('ssow_employee', function(Blueprint $table) {
			$table->dropForeign('ssow_employee_ssow_id_foreign');
		});
		Schema::table('ssow_employee', function(Blueprint $table) {
			$table->dropForeign('ssow_employee_status_id_foreign');
		});
		Schema::table('ssow_training', function(Blueprint $table) {
			$table->dropForeign('ssow_training_course_id_foreign');
		});
		Schema::table('ssow_training', function(Blueprint $table) {
			$table->dropForeign('ssow_training_employee_id_foreign');
		});
		Schema::table('ssow_course', function(Blueprint $table) {
			$table->dropForeign('ssow_course_category_id_foreign');
		});
	}
}