<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserProfileModel extends Model 
{

    protected $table = 'user_profile';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('user_id', 'address', 'city', 'phone', 'latitude', 'longitude');

    public function user()
    {
        return $this->belongsTo('App\User');
    }

}