<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VariantValuesModel extends Model 
{

    protected $table = 'variant_values';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('variant_id', 'name', 'values');

    public function variant()
    {
        return $this->belongsTo('App\VariantsModel');
    }

}