<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VendorProfileModel extends Model 
{

    protected $table = 'vendor_profile';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id', 'store_name', 'store_address', 'store_phone', 'store_city', 'store_logo', 'store_image', 'longitude', 'latitude', 'store_type');
    protected $fillable = array('user_id');
    protected $visible = array('user_id', 'store_address');

    public function user()
    {
        return $this->belongsTo('App\User');
    }

}