<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('name', 'email');
    protected $fillable = array('password', 'user_type', 'status');
    protected $visible = array('password', 'user_type', 'status');

    public function products()
    {
        return $this->hasMany('App\ProductsModel', 'user_id');
    }

    public function orders()
    {
        return $this->hasMany('App\OrdersModel', 'user_id');
    }

    public function StoreImages()
    {
        return $this->hasMany('App\StoreImages', 'user_id');
    }

}