<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxesTable extends Migration {

	public function up()
	{
		Schema::create('taxes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->nullable();
			$table->decimal('value')->default('0');
			$table->enum('status', array('Active', 'Inactive', 'Deleted'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('taxes');
	}
}