<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseAddressTable extends Migration {

	public function up()
	{
		Schema::create('purchase_address', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_order')->unsigned();
			$table->integer('id_user')->unsigned();
			$table->timestamps();
			$table->text('shipping_address');
			$table->string('first_name', 120);
			$table->string('last_name', 200);
			$table->string('city', 100);
			$table->string('state', 60);
			$table->string('country', 60);
			$table->text('additional_comment');
			$table->integer('zip_code');
		});
	}

	public function down()
	{
		Schema::drop('purchase_address');
	}
}