<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('state', array('active', 'packaging', 'packed', 'queued'));
			$table->timestamps();
			$table->bigInteger('fOrderId');
			$table->string('name');
			$table->boolean('isCod')->default(false);
			$table->float('codAmount')->nullable();
			$table->string('codCurrency')->nullable();
			$table->string('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}