<?php

namespace App;

class Poll extends Eloquent {

	protected $table = 'polls';
	public $timestamps = true;
	protected $fillable = array('meal_group_id', 'is_catered', 'is_active', 'date', 'expires_at', 'starts_at');

	public function choices()
	{
		return $this->hasMany('Poll_Choice', 'poll_id');
	}

	public function votes()
	{
		return $this->hasMany('Poll_Answer', 'poll_id');
	}

	public function comments()
	{
		return $this->hasMany('Comment', 'poll_id');
	}

}