<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePollsTable extends Migration {

	public function up()
	{
		Schema::create('polls', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('meal_group_id')->unsigned();
			$table->boolean('is_catered')->default(1);
			$table->boolean('is_active')->default(1);
			$table->timestamp('date');
			$table->timestamp('expires_at')->nullable();
			$table->timestamp('starts_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('polls');
	}
}