<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('unique_code');
			$table->string('password');
			$table->string('email')->unique();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('avatar', 500)->nullable();
			$table->boolean('is_special_needs')->default(0);
			$table->text('special_needs_details')->nullable();
			$table->boolean('is_admin')->default(0);
			$table->string('is_developer')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}