<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FinancialAccount extends Eloquent {

	protected $table = 'FinancialAccounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('AccountID', 'Name');
	protected $visible = array('AccountID', 'Name');

	public function FinancialData()
	{
		return $this->hasMany('BESTSELLER\FinancialData', 'AccountID', 'FinancialAccount');
	}

}