<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FinancialData extends Eloquent {

	protected $table = 'FinancialData';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('CostCenter', 'FinancialAccount', 'Month', 'Year', 'Value');
	protected $visible = array('CostCenter', 'FinancialAccount', 'Month', 'Year', 'Value');

	public function Store()
	{
		return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
	}

	public function FinancialAccount()
	{
		return $this->hasOne('BESTSELLER\FinancialAccount', 'AccountID', 'FinancialAccount');
	}

}