<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreStaffMonth extends Eloquent {

	protected $table = 'StoreStaffMonthly';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('StaffID', 'Salary', 'Wage', 'Allowance', 'Month', 'Year', 'SVType', 'ContractType', 'ContractHours', 'Position');
	protected $visible = array('StaffID', 'Salary', 'Wage', 'Allowance', 'Month', 'Year', 'SVType', 'ContractType', 'ContractHours', 'Position');

	public function StoreStaff()
	{
		return $this->belongsTo('BESTSELLER\StoreStaff', 'id', 'StaffID');
	}

	public function CostCenterShares()
	{
		return $this->hasMany('BESTSELLER\StoreStaffAssign', 'id', 'StaffMonthlyID');
	}

}