<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreData extends Model 
{

    protected $table = 'StoresData';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('CostCenter', 'ChainNum', 'ChainSlug', 'StoreName', 'RepCode', 'ContractNo', 'AreaManager', 'StoreFront', 'LocationType', 'State', 'PosCount', 'SQMContract', 'SQMSales', 'RentSplit', 'Top50JJ', 'StaffPerOpeningHours', 'OpenStoreVM', 'ComparableStatus', 'StatusType', 'ContractDate', 'ShopDate', 'TempClosingStartDate', 'TempClosingEndDate', 'RentContractStart', 'RentContractEnd', 'RentStore', 'RentStorage', 'RentOperationalCost');
    protected $visible = array('CostCenter', 'ChainNum', 'ChainSlug', 'StoreName', 'RepCode', 'ContractNo', 'AreaManager', 'StoreFront', 'LocationType', 'State', 'PosCount', 'SQMContract', 'SQMSales', 'RentSplit', 'Top50JJ', 'StaffPerOpeningHours', 'OpenStoreVM', 'ComparableStatus', 'StatusType', 'ContractDate', 'ShopDate', 'TempClosingStartDate', 'TempClosingEndDate', 'RentContractStart', 'RentContractEnd', 'RentStore', 'RentStorage', 'RentOperationalCost');

    public function SpecialDays()
    {
        return $this->hasMany('BESTSELLER\SpecialDay');
    }

    public function SalesData()
    {
        return $this->hasMany('BESTSELLER\SalesData', 'CostCenter', 'CostCenter');
    }

    public function WorkingHours()
    {
        return $this->hasMany('BESTSELLER\WorkingHours', 'CostCenter', 'CostCenter');
    }

    public function FinancialData()
    {
        return $this->hasMany('BESTSELLER\FinancialData', 'CostCenter', 'CostCenter');
    }

    public function DepreciationData()
    {
        return $this->hasMany('BESTSELLER\Depreciation', 'CostCenter', 'CostCenter');
    }

}