<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreStaffMonthlyTable extends Migration {

	public function up()
	{
		Schema::create('StoreStaffMonthly', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('StaffID')->unsigned();
			$table->decimal('Salary')->nullable();
			$table->decimal('Wage')->nullable();
			$table->decimal('Allowance')->nullable();
			$table->integer('Month');
			$table->integer('Year');
			$table->integer('SVType');
			$table->integer('ContractType');
			$table->decimal('ContractHours');
			$table->string('Position', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('StoreStaffMonthly');
	}
}