<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDataqualityTable extends Migration {

	public function up()
	{
		Schema::create('dataquality', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('trust_code')->nullable();
			$table->string('region_code')->nullable();
			$table->string('data_type');
			$table->string('pretreatment');
			$table->string('perf_status');
			$table->string('asa_grade_1');
			$table->string('asa_grade_2');
			$table->string('asa_grade_3');
			$table->string('asa_grade_4');
			$table->string('asa_grade_no_report');
			$table->string('risk_adjusted');
			$table->string('timespan');
			$table->smallInteger('num')->nullable();
			$table->smallInteger('num_resection')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('dataquality');
	}
}