<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->date('date_of_birth');
			$table->string('phone');
			$table->date('last_donation_date');
			$table->string('password');
			$table->integer('pin_code');
			$table->bigInteger('blood_type_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}