<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Parcel extends Eloquent {

	protected $table = 'parcels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('shipment_id', 'tracking_id', 'sender_id', 'receiver_id', 'length', 'width', 'height', 'weight');

	public function shipment()
	{
		return $this->belongsTo('App\Models\Shipment', 'shipment_id', 'id');
	}

}