<?php

namespace App\Models\Parcel;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ParcelItem extends Eloquent {

	protected $table = 'parcel_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('parcel_id', 'package_id');

	public function parcel()
	{
		return $this->belongsTo('App\Models\Parcel');
	}

}