<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHospitalAdmissionsTable extends Migration {

	public function up()
	{
		Schema::create('hospital_admissions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('case_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->enum('status', array('discharged', 'deceased', 'admitted'));
			$table->date('admition_date');
			$table->date('discharge_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hospital_admissions');
	}
}