<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldTable extends Migration {

	public function up()
	{
		Schema::create('field', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->enum('type', array('dropdown', 'text', 'switch'))->nullable();
			$table->string('name_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('field');
	}
}